# SEOgent Fix & Verify Workflow

This document describes the recommended iterative workflow for fixing SEO
issues discovered by SEOgent scans.

## Overview

1. **Scan** — Run a full-site audit to identify all issues
2. **Analyze** — Check site_checks first, then categorize page issues by scope
3. **Triage** — Prioritize site-wide template fixes over page-specific ones
4. **Fix** — Apply changes to the relevant source files
5. **Verify** — Re-scan only the affected URLs to confirm fixes
6. **Repeat** — Continue until all critical/high issues are resolved

## Example: Fixing Missing Canonical Tags (Site-Wide)

This is a template-level fix — one change improves every page.

### 1. Initial scan (async workflow)

```bash
# Step 1: Start scan
seogent scan example.com --quiet --dev
# Returns: { "scan_id": "scan_abc123", "status": "pending", ... }

# Step 2: Poll until completed
sleep 15 && seogent status scan_abc123 --quiet --dev
# Repeat if still "pending", "crawling", or "analyzing"

# Step 3: Fetch results (save to file for large sites)
seogent results scan_abc123 --quiet --dev > results.json
```

### 2. Identify the scope

Check `top_issues` to see how many pages are affected:
```bash
jq '.top_issues[] | select(.issue | test("canonical"; "i"))' results.json
```

Output:
```json
{ "issue": "Missing canonical tag", "count": 28 }
```

28 out of 32 pages — this is a site-wide template issue. Fix the base
layout once and all 28 pages improve.

### 3. Fix the base template

Add a self-referencing canonical tag to the `<head>` in the base layout.
The URL should be generated from the request URI so each page gets its
own canonical automatically.

### 4. Verify with a targeted re-scan

Pick a few representative pages to verify:
```bash
# Start verification scan
seogent scan https://example.com/ \
  --urls https://example.com/about \
  --urls https://example.com/products \
  --quiet --dev
# Returns scan_id

# Poll
sleep 15 && seogent status <scan_id> --quiet --dev

# Check results
seogent results <scan_id> --quiet --dev
```

### 5. Confirm the fix

```bash
jq '[.results.data[] | select(.failed_checks[] | test("canonical"; "i"))] | length' verify-results.json
```

If the result is `0`, the fix was successful across the sampled pages.

## Example: Fixing Page-Specific Issues

### Missing meta description on /about

This only affects one page, so fix the page's own template or content:

```bash
# After fixing, verify just that page
seogent scan https://example.com/about --quiet --dev
# Poll and fetch results as usual
```

## Tips

- **Site-wide first** — fix template-level issues before page-specific ones.
  One template fix can improve 20+ pages at once.
- Always re-scan specific URLs rather than the full site for verification —
  it's faster and uses fewer credits.
- Group related fixes together (e.g., all missing meta descriptions) and
  verify them in a single targeted scan.
- For large sites (30+ pages), delegate result analysis to a subagent to
  avoid exceeding context limits.
- Use `--min-severity high` when reviewing results to focus on what matters
  most for search rankings.
- Results may include 404 pages discovered via broken internal links — these
  aren't fixable SEO pages. Fix the broken links instead.
