#!/bin/bash
# scan.sh - SEOgent scan with automatic polling
# Usage: ./scan.sh <url> [max-pages]

URL=$1
MAX_PAGES=${2:-100}

if [ -z "$URL" ]; then
  echo "Usage: ./scan.sh <url> [max-pages]"
  exit 1
fi

if [ -z "$SEOGENT_API_KEY" ]; then
  # Check if auth is configured in config file
  if ! seogent auth --show > /dev/null 2>&1; then
    echo "Error: No API key configured. Run 'seogent auth <token>' or set SEOGENT_API_KEY"
    exit 2
  fi
fi

# Start scan (--quiet for JSON output)
echo "Starting scan of $URL (max $MAX_PAGES pages)..." >&2
RESULT=$(seogent scan "$URL" --max-pages $MAX_PAGES --quiet --dev)
SCAN_ID=$(echo $RESULT | jq -r '.scan_id')

if [ -z "$SCAN_ID" ] || [ "$SCAN_ID" = "null" ]; then
  echo "Failed to start scan" >&2
  echo "$RESULT" >&2
  exit 1
fi

echo "Scan ID: $SCAN_ID" >&2

# Poll for completion
while true; do
  sleep 15
  STATUS_JSON=$(seogent status $SCAN_ID --quiet --dev)
  STATUS=$(echo $STATUS_JSON | jq -r '.status')

  echo "Status: $STATUS" >&2

  if [ "$STATUS" = "completed" ]; then
    seogent results $SCAN_ID --quiet --dev
    exit 0
  fi

  if [ "$STATUS" = "failed" ]; then
    echo "Scan failed" >&2
    echo "$STATUS_JSON" >&2
    exit 1
  fi

  # "pending", "crawling", or "analyzing" — loop continues
done
